'*************************************************************
' 
' ADOBE SYSTEMS INCORPORATED 
' Copyright 2005-2010 Adobe Systems Incorporated 
' All Rights Reserved 

' NOTICE:  Adobe permits you to use, modify, and 
' distribute this file in accordance with the terms
' of the Adobe license agreement accompanying it.  
' If you have received this file from a source 
' other than Adobe, then your use, modification,
' or distribution of it requires the prior 
' written permission of Adobe. 
' 
'*************************************************************

' Get Selection.vbs

' DESCRIPTION

' This example illustrates different ways of using the 
' selection property. Try to run it with text selected, 
' paths selected and the bounding box of text art items selected.
' 
'*************************************************************

GetTextSelection

Private Sub GetTextSelection
	Set appRef = CreateObject("Illustrator.Application")

	If (appRef.Documents.Count < 1) Then
		appRef.DoJavaScript "alert('Open document and select some text items.')"
		' OR
		' MsgBox "Open document and select some text items."
		Exit Sub
	End If

	If (IsEmpty(appRef.Selection)) Then
		appRef.DoJavaScript "alert('Nothing is selected.')"
		' OR
		' MsgBox "Nothing is selected"
		Exit Sub
	End If
    
	Rem If the user has selected characters inside a text art item then the type of
	Rem the selection is string

	If (TypeName(appRef.Selection) = "TextRange") Then
		myMsg = "alert(""The following text is selected: > " & appRef.Selection.Contents & "<"")"
		appRef.DoJavaScript myMsg
		' MsgBox "The following text is selected: >" & appRef.Selection.Contents & "<"
		Exit Sub
	End If
     
	Rem If one or more art items are selected then a variant array of Objects is returned
	
	selectedItems = appRef.Selection
	If (TypeName(selectedItems) <> "Variant()") Then
		myMsg = "alert(""Unknown selection type = " & TypeName(selectedItems) & ")"
		appRef.DoJavaScript myMsg
		' MsgBox "Unknown selection type = " & TypeName(selectedItems)
		Exit Sub
	End If
	    
	Rem run through the returned array
	Rem (startIndex will always be 0)

	startIndex = LBound(selectedItems)
	endIndex = UBound(selectedItems)
	
	For index = startIndex To endIndex
		Set pageObject = selectedItems(index)
        
		Set artItem = pageObject.PageItem
		If (artItem.PageItemType = 10 ) Then ' chk if aiTextFrame
			myMsg = "alert(""Text art item selected: >" & artItem.Contents & "<"")"
			appRef.DoJavaScript myMsg
			' MsgBox "Text art item selected: >" & artItem.Contents & "<"
		Else
			myMsg = "alert(""Selection: " & TypeName(pageObject) & """)"
			appRef.DoJavaScript myMsg
			' MsgBox TypeName(pageObject)
		End If
	Next
End Sub
'' SIG '' Begin signature block
'' SIG '' MIIpyQYJKoZIhvcNAQcCoIIpujCCKbYCAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' ikNgKwBi8yFmGh7QWDPbkfcUHDPDH6yXu59B8XDvijig
'' SIG '' gg6WMIIGsDCCBJigAwIBAgIQCK1AsmDSnEyfXs2pvZOu
'' SIG '' 2TANBgkqhkiG9w0BAQwFADBiMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdpQ2Vy
'' SIG '' dCBUcnVzdGVkIFJvb3QgRzQwHhcNMjEwNDI5MDAwMDAw
'' SIG '' WhcNMzYwNDI4MjM1OTU5WjBpMQswCQYDVQQGEwJVUzEX
'' SIG '' MBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMT
'' SIG '' OERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5n
'' SIG '' IFJTQTQwOTYgU0hBMzg0IDIwMjEgQ0ExMIICIjANBgkq
'' SIG '' hkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA1bQvQtAorXi3
'' SIG '' XdU5WRuxiEL1M4zrPYGXcMW7xIUmMJ+kjmjYXPXrNCQH
'' SIG '' 4UtP03hD9BfXHtr50tVnGlJPDqFX/IiZwZHMgQM+TXAk
'' SIG '' ZLON4gh9NH1MgFcSa0OamfLFOx/y78tHWhOmTLMBICXz
'' SIG '' ENOLsvsI8IrgnQnAZaf6mIBJNYc9URnokCF4RS6hnyzh
'' SIG '' GMIazMXuk0lwQjKP+8bqHPNlaJGiTUyCEUhSaN4QvRRX
'' SIG '' XegYE2XFf7JPhSxIpFaENdb5LpyqABXRN/4aBpTCfMjq
'' SIG '' GzLmysL0p6MDDnSlrzm2q2AS4+jWufcx4dyt5Big2MEj
'' SIG '' R0ezoQ9uo6ttmAaDG7dqZy3SvUQakhCBj7A7CdfHmzJa
'' SIG '' wv9qYFSLScGT7eG0XOBv6yb5jNWy+TgQ5urOkfW+0/tv
'' SIG '' k2E0XLyTRSiDNipmKF+wc86LJiUGsoPUXPYVGUztYuBe
'' SIG '' M/Lo6OwKp7ADK5GyNnm+960IHnWmZcy740hQ83eRGv7b
'' SIG '' UKJGyGFYmPV8AhY8gyitOYbs1LcNU9D4R+Z1MI3sMJN2
'' SIG '' FKZbS110YU0/EpF23r9Yy3IQKUHw1cVtJnZoEUETWJrc
'' SIG '' JisB9IlNWdt4z4FKPkBHX8mBUHOFECMhWWCKZFTBzCEa
'' SIG '' 6DgZfGYczXg4RTCZT/9jT0y7qg0IU0F8WD1Hs/q27Iwy
'' SIG '' CQLMbDwMVhECAwEAAaOCAVkwggFVMBIGA1UdEwEB/wQI
'' SIG '' MAYBAf8CAQAwHQYDVR0OBBYEFGg34Ou2O/hfEYb7/mF7
'' SIG '' CIhl9E5CMB8GA1UdIwQYMBaAFOzX44LScV1kTN8uZz/n
'' SIG '' upiuHA9PMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAK
'' SIG '' BggrBgEFBQcDAzB3BggrBgEFBQcBAQRrMGkwJAYIKwYB
'' SIG '' BQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBB
'' SIG '' BggrBgEFBQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNl
'' SIG '' cnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQw
'' SIG '' QwYDVR0fBDwwOjA4oDagNIYyaHR0cDovL2NybDMuZGln
'' SIG '' aWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5j
'' SIG '' cmwwHAYDVR0gBBUwEzAHBgVngQwBAzAIBgZngQwBBAEw
'' SIG '' DQYJKoZIhvcNAQEMBQADggIBADojRD2NCHbuj7w6mdNW
'' SIG '' 4AIapfhINPMstuZ0ZveUcrEAyq9sMCcTEp6QRJ9L/Z6j
'' SIG '' fCbVN7w6XUhtldU/SfQnuxaBRVD9nL22heB2fjdxyyL3
'' SIG '' WqqQz/WTauPrINHVUHmImoqKwba9oUgYftzYgBoRGRjN
'' SIG '' YZmBVvbJ43bnxOQbX0P4PpT/djk9ntSZz0rdKOtfJqGV
'' SIG '' WEjVGv7XJz/9kNF2ht0csGBc8w2o7uCJob054ThO2m67
'' SIG '' Np375SFTWsPK6Wrxoj7bQ7gzyE84FJKZ9d3OVG3ZXQIU
'' SIG '' H0AzfAPilbLCIXVzUstG2MQ0HKKlS43Nb3Y3LIU/Gs4m
'' SIG '' 6Ri+kAewQ3+ViCCCcPDMyu/9KTVcH4k4Vfc3iosJocsL
'' SIG '' 6TEa/y4ZXDlx4b6cpwoG1iZnt5LmTl/eeqxJzy6kdJKt
'' SIG '' 2zyknIYf48FWGysj/4+16oh7cGvmoLr9Oj9FpsToFpFS
'' SIG '' i0HASIRLlk2rREDjjfAVKM7t8RhWByovEMQMCGQ8M4+u
'' SIG '' KIw8y4+ICw2/O/TOHnuO77Xry7fwdxPm5yg/rBKupS8i
'' SIG '' bEH5glwVZsxsDsrFhsP2JjMMB0ug0wcCampAMEhLNKhR
'' SIG '' ILutG4UI4lkNbcoFUCvqShyepf2gpx8GdOfy1lKQ/a+F
'' SIG '' SCH5Vzu0nAPthkX0tGFuv2jiJmCG6sivqf6UHedjGzqG
'' SIG '' VnhOMIIH3jCCBcagAwIBAgIQD99ExMbwCe2qSx8hp1o/
'' SIG '' EDANBgkqhkiG9w0BAQsFADBpMQswCQYDVQQGEwJVUzEX
'' SIG '' MBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMT
'' SIG '' OERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5n
'' SIG '' IFJTQTQwOTYgU0hBMzg0IDIwMjEgQ0ExMB4XDTIzMTEw
'' SIG '' MzAwMDAwMFoXDTI1MTEwNDIzNTk1OVowgeYxEzARBgsr
'' SIG '' BgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIBAhMI
'' SIG '' RGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3JnYW5p
'' SIG '' emF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYDVQQG
'' SIG '' EwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNhbiBK
'' SIG '' b3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYDVQQL
'' SIG '' EyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29weSwg
'' SIG '' TXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCAiIwDQYJ
'' SIG '' KoZIhvcNAQEBBQADggIPADCCAgoCggIBAPCR5c/cgyg4
'' SIG '' MpJD46/+BWENPhE1RjN77VE2BWlIUdiO2nlWelKthEq9
'' SIG '' aK+1ofKIlDVc9mvxksuXBLESi7HBt3PCVBntNJkjBJd0
'' SIG '' EXeprmDK8HZrz8y/KSwEewbTMjneMRIRcJV2GMoAyUzK
'' SIG '' EyFJF7m6ByeoNBDDXMD4AQF5C2l3wfvRbREw+G+cyeya
'' SIG '' 564AHpFJ9sfqi9jAycnEZISxEf6N72GgGQr04cZt3JTb
'' SIG '' TktZGt6uWdZnseXDLGRHzFu4P4EqmVKvfMDliaKyWBzV
'' SIG '' lY+gmtE1vSxIK79WTySFrFY5j1vtbKyHybk6tv4TOmLt
'' SIG '' Lw4OP/ngVDiw/ZP+b7saGxPOEfuh5LOAr+llt+6V5NhT
'' SIG '' dkYPR6cbokawwX2DbGg7IeVuUPdf9bx/LznFV/8kPxCB
'' SIG '' J6qg0dqvCmQt/XbBXPJUvDoVJ9z+9hDlrAoLESqpHK8U
'' SIG '' 73UFGohBMJ/7itIyKngem7Ms98z6x0i63FJA8C06g+XE
'' SIG '' GJUmR28+c6ba+m/sc6xHI4zdL5a84UeRS9+u8UL8N4av
'' SIG '' fpSxHYTTxVjk1ZlwQ8dLARwEVWvTu4lRcEck3RPogx7o
'' SIG '' o8wUpSw9++m+Oi+K/z7RP/R67uCEtrkdM5N/xUoQR/t6
'' SIG '' 3P2ia9g8+LuYJ2BNBd1+qMcSoSlDfIFLFMeeqESbMv+j
'' SIG '' UsRQJn2lZvufAgMBAAGjggICMIIB/jAfBgNVHSMEGDAW
'' SIG '' gBRoN+Drtjv4XxGG+/5hewiIZfROQjAdBgNVHQ4EFgQU
'' SIG '' RPnrJ9yT26rMrd/Q4PfQSlgeaRcwPQYDVR0gBDYwNDAy
'' SIG '' BgVngQwBAzApMCcGCCsGAQUFBwIBFhtodHRwOi8vd3d3
'' SIG '' LmRpZ2ljZXJ0LmNvbS9DUFMwDgYDVR0PAQH/BAQDAgeA
'' SIG '' MBMGA1UdJQQMMAoGCCsGAQUFBwMDMIG1BgNVHR8Ega0w
'' SIG '' gaowU6BRoE+GTWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNv
'' SIG '' bS9EaWdpQ2VydFRydXN0ZWRHNENvZGVTaWduaW5nUlNB
'' SIG '' NDA5NlNIQTM4NDIwMjFDQTEuY3JsMFOgUaBPhk1odHRw
'' SIG '' Oi8vY3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVz
'' SIG '' dGVkRzRDb2RlU2lnbmluZ1JTQTQwOTZTSEEzODQyMDIx
'' SIG '' Q0ExLmNybDCBlAYIKwYBBQUHAQEEgYcwgYQwJAYIKwYB
'' SIG '' BQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBc
'' SIG '' BggrBgEFBQcwAoZQaHR0cDovL2NhY2VydHMuZGlnaWNl
'' SIG '' cnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZEc0Q29kZVNpZ25p
'' SIG '' bmdSU0E0MDk2U0hBMzg0MjAyMUNBMS5jcnQwCQYDVR0T
'' SIG '' BAIwADANBgkqhkiG9w0BAQsFAAOCAgEAPIZ9C4IuKg85
'' SIG '' 0H8M66OLMVllIpANmEjijIG/D65qP6jfma+2WFps2bb+
'' SIG '' vKKIEtG9TFtCAlSrA1OV6Ru78paq0gqw/q3QAN0OleFR
'' SIG '' F1NvT/TLO0ulhjXTETB1BwSKZaJH001DH0+60TmbGfVh
'' SIG '' mwLrEj2Zfl4COFwivZ/2tRoknZl5tmiu4hpjDbOapWd9
'' SIG '' 5cqliSoMeu2i588557eikdiDk6bXBa5MxHjyXvbvaIWN
'' SIG '' Zjsymn0L0sYkF3BToDN0h0XiTTZjZPHdSV2GjX6C/+Nj
'' SIG '' HSZGRtBaIxdAL1mKEWJV9qkEKELPb098rO+zGdn1E5IH
'' SIG '' pS1zSRIYngwZEjZfyoCkg1F+EW4QPs2+ff2CsW5i3IEd
'' SIG '' 7vL19w9oyce3S4wejvnlTKt+EQWn3gSPxrbkp3BxdWRN
'' SIG '' 25MKo5bS5bJ21BiwqcIJHcTxWNgaQPh4sZboi9IimCSn
'' SIG '' UenPQhqdeOuz0NnmepMEYd7L/kqnAeUZ8bW1UbITAWQ/
'' SIG '' UT3phjCfRQNpEh4OBoUcH8hOOHZ0Lh86mxv9lDP3i7c/
'' SIG '' bQzZnrJr2dS34JXolwREbTX9Yu5JB5X3YP539/M1Ms5O
'' SIG '' FZou/MHQBrWMsVBsEXDTWqwbMTYw/zvIiHXcGUnpzInw
'' SIG '' 1jQXlLrmwVHW4ug+A4LFO7bWC4mnZoDNWp0xnlGmbP6I
'' SIG '' ccJmW5C7RJMxghqLMIIahwIBATB9MGkxCzAJBgNVBAYT
'' SIG '' AlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjFBMD8G
'' SIG '' A1UEAxM4RGlnaUNlcnQgVHJ1c3RlZCBHNCBDb2RlIFNp
'' SIG '' Z25pbmcgUlNBNDA5NiBTSEEzODQgMjAyMSBDQTECEA/f
'' SIG '' RMTG8AntqksfIadaPxAwDQYJYIZIAWUDBAIBBQCggaIw
'' SIG '' GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
'' SIG '' BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcN
'' SIG '' AQkEMSIEIEuvy+T4xR403b+VFsJKL8fDbViq3kdchiEd
'' SIG '' y2l9F3DPMDYGCisGAQQBgjcCAQwxKDAmoCSAIgBBAGQA
'' SIG '' bwBiAGUAIABJAGwAbAB1AHMAdAByAGEAdABvAHIwDQYJ
'' SIG '' KoZIhvcNAQEBBQAEggIAlagUw6co+qc1GdWBKQIUolsQ
'' SIG '' CG8PExJNRS6Vc+IqmaWy9DRX+Ur0t95LYn3g11dkoWEN
'' SIG '' D9ocZWCnB1Nugghk2XmnRKkq+ckQGI9Ph1/jSlx/o7FG
'' SIG '' dd9liuXMYcnvqspjGeFViNELNke+Cb3hYH7W1a/mvp5p
'' SIG '' Y7ZKzigAMyZUexqLov35S37+oKPola9TwB4k0ckEVVAs
'' SIG '' zbr2Fd1nQK+gfLYqCGcJZ0ncIIvp+1I8p5g4bNbkOvTA
'' SIG '' VzuFzfKh3EyuvfWbO2lTlXkPQtxdquknesfN8s4Rgj/2
'' SIG '' Ky3i0ZUiyok9sjMiZC89ktiBIz6r3S+IX7eXImpjKVP7
'' SIG '' EfbArUTEVQFlwe+5NANipvSJ9wLpLV0Ct+w5UKHFBCr0
'' SIG '' PZiq5ATY821igddtMl9NMm28z/+3cT68yxv618Lkqqk3
'' SIG '' vUxTRYXH1Ap4t3hLqafWNzQjtsF7Pka+8FhaB7/Hh5Z1
'' SIG '' 3/gm3a7tFOwKhX70RluxTV75Pr/q6neodzrrIHQe2dnf
'' SIG '' ul8xix2/4rfNCZjXvuD5pjwLudFD+3ssGPjqALwuwYqE
'' SIG '' x/Em7JVwI6SbNF76xmdiLbgZmGrnBGa1+FWn2xO792OV
'' SIG '' ZOCYRNZIl67c7IDUD89fsxlRnelt65iQgz2AxX8cARGg
'' SIG '' hzUuqv5iLNhRq3IThUs25J4z0aaBl0/1A+dcWCMhJAeh
'' SIG '' ghc6MIIXNgYKKwYBBAGCNwMDATGCFyYwghciBgkqhkiG
'' SIG '' 9w0BBwKgghcTMIIXDwIBAzEPMA0GCWCGSAFlAwQCAQUA
'' SIG '' MHgGCyqGSIb3DQEJEAEEoGkEZzBlAgEBBglghkgBhv1s
'' SIG '' BwEwMTANBglghkgBZQMEAgEFAAQg1UrcDuxPPKGACFYU
'' SIG '' j4HRp7so7uH45mWANKVGrLn6JOgCEQDdqeQjdAqJBEqJ
'' SIG '' d+BZdQEMGA8yMDI1MDQxNzE0MzkyN1qgghMDMIIGvDCC
'' SIG '' BKSgAwIBAgIQC65mvFq6f5WHxvnpBOMzBDANBgkqhkiG
'' SIG '' 9w0BAQsFADBjMQswCQYDVQQGEwJVUzEXMBUGA1UEChMO
'' SIG '' RGlnaUNlcnQsIEluYy4xOzA5BgNVBAMTMkRpZ2lDZXJ0
'' SIG '' IFRydXN0ZWQgRzQgUlNBNDA5NiBTSEEyNTYgVGltZVN0
'' SIG '' YW1waW5nIENBMB4XDTI0MDkyNjAwMDAwMFoXDTM1MTEy
'' SIG '' NTIzNTk1OVowQjELMAkGA1UEBhMCVVMxETAPBgNVBAoT
'' SIG '' CERpZ2lDZXJ0MSAwHgYDVQQDExdEaWdpQ2VydCBUaW1l
'' SIG '' c3RhbXAgMjAyNDCCAiIwDQYJKoZIhvcNAQEBBQADggIP
'' SIG '' ADCCAgoCggIBAL5qc5/2lSGrljC6W23mWaO16P2RHxjE
'' SIG '' iDtqmeOlwf0KMCBDEr4IxHRGd7+L660x5XltSVhhK64z
'' SIG '' i9CeC9B6lUdXM0s71EOcRe8+CEJp+3R2O8oo76EO7o5t
'' SIG '' Luslxdr9Qq82aKcpA9O//X6QE+AcaU/byaCagLD/GLoU
'' SIG '' b35SfWHh43rOH3bpLEx7pZ7avVnpUVmPvkxT8c2a2yC0
'' SIG '' WMp8hMu60tZR0ChaV76Nhnj37DEYTX9ReNZ8hIOYe4jl
'' SIG '' 7/r419CvEYVIrH6sN00yx49boUuumF9i2T8UuKGn9966
'' SIG '' fR5X6kgXj3o5WHhHVO+NBikDO0mlUh902wS/Eeh8F/UF
'' SIG '' aRp1z5SnROHwSJ+QQRZ1fisD8UTVDSupWJNstVkiqLq+
'' SIG '' ISTdEjJKGjVfIcsgA4l9cbk8Smlzddh4EfvFrpVNnes4
'' SIG '' c16Jidj5XiPVdsn5n10jxmGpxoMc6iPkoaDhi6JjHd5i
'' SIG '' bfdp5uzIXp4P0wXkgNs+CO/CacBqU0R4k+8h6gYldp4F
'' SIG '' CMgrXdKWfM4N0u25OEAuEa3JyidxW48jwBqIJqImd93N
'' SIG '' Rxvd1aepSeNeREXAu2xUDEW8aqzFQDYmr9ZONuc2MhTM
'' SIG '' izchNULpUEoA6Vva7b1XCB+1rxvbKmLqfY/M/SdV6mwW
'' SIG '' TyeVy5Z/JkvMFpnQy5wR14GJcv6dQ4aEKOX5AgMBAAGj
'' SIG '' ggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/
'' SIG '' BAIwADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNV
'' SIG '' HSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEwHwYD
'' SIG '' VR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYD
'' SIG '' VR0OBBYEFJ9XLAN3DigVkGalY17uT5IfdqBbMFoGA1Ud
'' SIG '' HwRTMFEwT6BNoEuGSWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
'' SIG '' LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEy
'' SIG '' NTZUaW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEB
'' SIG '' BIGDMIGAMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5k
'' SIG '' aWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9j
'' SIG '' YWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0
'' SIG '' ZWRHNFJTQTQwOTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5j
'' SIG '' cnQwDQYJKoZIhvcNAQELBQADggIBAD2tHh92mVvjOIQS
'' SIG '' R9lDkfYR25tOCB3RKE/P09x7gUsmXqt40ouRl3lj+8Qi
'' SIG '' oVYq3igpwrPvBmZdrlWBb0HvqT00nFSXgmUrDKNSQqGT
'' SIG '' dpjHsPy+LaalTW0qVjvUBhcHzBMutB6HzeledbDCzFzU
'' SIG '' y34VarPnvIWrqVogK0qM8gJhh/+qDEAIdO/KkYesLyTV
'' SIG '' OoJ4eTq7gj9UFAL1UruJKlTnCVaM2UeUUW/8z3fvjxhN
'' SIG '' 6hdT98Vr2FYlCS7Mbb4Hv5swO+aAXxWUm3WpByXtgVQx
'' SIG '' iBlTVYzqfLDbe9PpBKDBfk+rabTFDZXoUke7zPgtd7/f
'' SIG '' vWTlCs30VAGEsshJmLbJ6ZbQ/xll/HjO9JbNVekBv2Tg
'' SIG '' em+mLptR7yIrpaidRJXrI+UzB6vAlk/8a1u7cIqV0yef
'' SIG '' 4uaZFORNekUgQHTqddmsPCEIYQP7xGxZBIhdmm4bhYsV
'' SIG '' A6G2WgNFYagLDBzpmk9104WQzYuVNsxyoVLObhx3Ruga
'' SIG '' EGru+SojW4dHPoWrUhftNpFC5H7QEY7MhKRyrBe7ucyk
'' SIG '' W7eaCuWBsBb4HOKRFVDcrZgdwaSIqMDiCLg4D+TPVgKx
'' SIG '' 2EgEdeoHNHT9l3ZDBD+XgbF+23/zBjeCtxz+dL/9NWR6
'' SIG '' P2eZRi7zcEO1xwcdcqJsyz/JceENc2Sg8h3KeFUCS7tp
'' SIG '' Fk7CrDqkMIIGrjCCBJagAwIBAgIQBzY3tyRUfNhHrP0o
'' SIG '' ZipeWzANBgkqhkiG9w0BAQsFADBiMQswCQYDVQQGEwJV
'' SIG '' UzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQL
'' SIG '' ExB3d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdp
'' SIG '' Q2VydCBUcnVzdGVkIFJvb3QgRzQwHhcNMjIwMzIzMDAw
'' SIG '' MDAwWhcNMzcwMzIyMjM1OTU5WjBjMQswCQYDVQQGEwJV
'' SIG '' UzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNV
'' SIG '' BAMTMkRpZ2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBT
'' SIG '' SEEyNTYgVGltZVN0YW1waW5nIENBMIICIjANBgkqhkiG
'' SIG '' 9w0BAQEFAAOCAg8AMIICCgKCAgEAxoY1BkmzwT1ySVFV
'' SIG '' xyUDxPKRN6mXUaHW0oPRnkyibaCwzIP5WvYRoUQVQl+k
'' SIG '' iPNo+n3znIkLf50fng8zH1ATCyZzlm34V6gCff1DtITa
'' SIG '' EfFzsbPuK4CEiiIY3+vaPcQXf6sZKz5C3GeO6lE98NZW
'' SIG '' 1OcoLevTsbV15x8GZY2UKdPZ7Gnf2ZCHRgB720RBidx8
'' SIG '' ald68Dd5n12sy+iEZLRS8nZH92GDGd1ftFQLIWhuNyG7
'' SIG '' QKxfst5Kfc71ORJn7w6lY2zkpsUdzTYNXNXmG6jBZHRA
'' SIG '' p8ByxbpOH7G1WE15/tePc5OsLDnipUjW8LAxE6lXKZYn
'' SIG '' LvWHpo9OdhVVJnCYJn+gGkcgQ+NDY4B7dW4nJZCYOjgR
'' SIG '' s/b2nuY7W+yB3iIU2YIqx5K/oN7jPqJz+ucfWmyU8lKV
'' SIG '' EStYdEAoq3NDzt9KoRxrOMUp88qqlnNCaJ+2RrOdOqPV
'' SIG '' A+C/8KI8ykLcGEh/FDTP0kyr75s9/g64ZCr6dSgkQe1C
'' SIG '' vwWcZklSUPRR8zZJTYsg0ixXNXkrqPNFYLwjjVj33GHe
'' SIG '' k/45wPmyMKVM1+mYSlg+0wOI/rOP015LdhJRk8mMDDtb
'' SIG '' iiKowSYI+RQQEgN9XyO7ZONj4KbhPvbCdLI/Hgl27Ktd
'' SIG '' RnXiYKNYCQEoAA6EVO7O6V3IXjASvUaetdN2udIOa5kM
'' SIG '' 0jO0zbECAwEAAaOCAV0wggFZMBIGA1UdEwEB/wQIMAYB
'' SIG '' Af8CAQAwHQYDVR0OBBYEFLoW2W1NhS9zKXaaL3WMaiCP
'' SIG '' nshvMB8GA1UdIwQYMBaAFOzX44LScV1kTN8uZz/nupiu
'' SIG '' HA9PMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggr
'' SIG '' BgEFBQcDCDB3BggrBgEFBQcBAQRrMGkwJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBBBggr
'' SIG '' BgEFBQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQwQwYD
'' SIG '' VR0fBDwwOjA4oDagNIYyaHR0cDovL2NybDMuZGlnaWNl
'' SIG '' cnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcmww
'' SIG '' IAYDVR0gBBkwFzAIBgZngQwBBAIwCwYJYIZIAYb9bAcB
'' SIG '' MA0GCSqGSIb3DQEBCwUAA4ICAQB9WY7Ak7ZvmKlEIgF+
'' SIG '' ZtbYIULhsBguEE0TzzBTzr8Y+8dQXeJLKftwig2qKWn8
'' SIG '' acHPHQfpPmDI2AvlXFvXbYf6hCAlNDFnzbYSlm/EUExi
'' SIG '' HQwIgqgWvalWzxVzjQEiJc6VaT9Hd/tydBTX/6tPiix6
'' SIG '' q4XNQ1/tYLaqT5Fmniye4Iqs5f2MvGQmh2ySvZ180HAK
'' SIG '' fO+ovHVPulr3qRCyXen/KFSJ8NWKcXZl2szwcqMj+sAn
'' SIG '' gkSumScbqyQeJsG33irr9p6xeZmBo1aGqwpFyd/EjaDn
'' SIG '' mPv7pp1yr8THwcFqcdnGE4AJxLafzYeHJLtPo0m5d2aR
'' SIG '' 8XKc6UsCUqc3fpNTrDsdCEkPlM05et3/JWOZJyw9P2un
'' SIG '' 8WbDQc1PtkCbISFA0LcTJM3cHXg65J6t5TRxktcma+Q4
'' SIG '' c6umAU+9Pzt4rUyt+8SVe+0KXzM5h0F4ejjpnOHdI/0d
'' SIG '' KNPH+ejxmF/7K9h+8kaddSweJywm228Vex4Ziza4k9Tm
'' SIG '' 8heZWcpw8De/mADfIBZPJ/tgZxahZrrdVcA6KYawmKAr
'' SIG '' 7ZVBtzrVFZgxtGIJDwq9gdkT/r+k0fNX2bwE+oLeMt8E
'' SIG '' ifAAzV3C+dAjfwAL5HYCJtnwZXZCpimHCUcr5n8apIUP
'' SIG '' /JiW9lVUKx+A+sDyDivl1vupL0QVSucTDh3bNzgaoSv2
'' SIG '' 7dZ8/DCCBY0wggR1oAMCAQICEA6bGI750C3n79tQ4ghA
'' SIG '' GFowDQYJKoZIhvcNAQEMBQAwZTELMAkGA1UEBhMCVVMx
'' SIG '' FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQ
'' SIG '' d3d3LmRpZ2ljZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNl
'' SIG '' cnQgQXNzdXJlZCBJRCBSb290IENBMB4XDTIyMDgwMTAw
'' SIG '' MDAwMFoXDTMxMTEwOTIzNTk1OVowYjELMAkGA1UEBhMC
'' SIG '' VVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UE
'' SIG '' CxMQd3d3LmRpZ2ljZXJ0LmNvbTEhMB8GA1UEAxMYRGln
'' SIG '' aUNlcnQgVHJ1c3RlZCBSb290IEc0MIICIjANBgkqhkiG
'' SIG '' 9w0BAQEFAAOCAg8AMIICCgKCAgEAv+aQc2jeu+RdSjww
'' SIG '' IjBpM+zCpyUuySE98orYWcLhKac9WKt2ms2uexuEDcQw
'' SIG '' H/MbpDgW61bGl20dq7J58soR0uRf1gU8Ug9SH8aeFaV+
'' SIG '' vp+pVxZZVXKvaJNwwrK6dZlqczKU0RBEEC7fgvMHhOZ0
'' SIG '' O21x4i0MG+4g1ckgHWMpLc7sXk7Ik/ghYZs06wXGXuxb
'' SIG '' Grzryc/NrDRAX7F6Zu53yEioZldXn1RYjgwrt0+nMNlW
'' SIG '' 7sp7XeOtyU9e5TXnMcvak17cjo+A2raRmECQecN4x7ax
'' SIG '' xLVqGDgDEI3Y1DekLgV9iPWCPhCRcKtVgkEy19sEcypu
'' SIG '' kQF8IUzUvK4bA3VdeGbZOjFEmjNAvwjXWkmkwuapoGfd
'' SIG '' pCe8oU85tRFYF/ckXEaPZPfBaYh2mHY9WV1CdoeJl2l6
'' SIG '' SPDgohIbZpp0yt5LHucOY67m1O+SkjqePdwA5EUlibaa
'' SIG '' RBkrfsCUtNJhbesz2cXfSwQAzH0clcOP9yGyshG3u3/y
'' SIG '' 1YxwLEFgqrFjGESVGnZifvaAsPvoZKYz0YkH4b235kOk
'' SIG '' GLimdwHhD5QMIR2yVCkliWzlDlJRR3S+Jqy2QXXeeqxf
'' SIG '' jT/JvNNBERJb5RBQ6zHFynIWIgnffEx1P2PsIV/EIFFr
'' SIG '' b7GrhotPwtZFX50g/KEexcCPorF+CiaZ9eRpL5gdLfXZ
'' SIG '' qbId5RsCAwEAAaOCATowggE2MA8GA1UdEwEB/wQFMAMB
'' SIG '' Af8wHQYDVR0OBBYEFOzX44LScV1kTN8uZz/nupiuHA9P
'' SIG '' MB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6enIZ3zbcgP
'' SIG '' MA4GA1UdDwEB/wQEAwIBhjB5BggrBgEFBQcBAQRtMGsw
'' SIG '' JAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
'' SIG '' LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMu
'' SIG '' ZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9v
'' SIG '' dENBLmNydDBFBgNVHR8EPjA8MDqgOKA2hjRodHRwOi8v
'' SIG '' Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVk
'' SIG '' SURSb290Q0EuY3JsMBEGA1UdIAQKMAgwBgYEVR0gADAN
'' SIG '' BgkqhkiG9w0BAQwFAAOCAQEAcKC/Q1xV5zhfoKN0Gz22
'' SIG '' Ftf3v1cHvZqsoYcs7IVeqRq7IviHGmlUIu2kiHdtvRoU
'' SIG '' 9BNKei8ttzjv9P+Aufih9/Jy3iS8UgPITtAq3votVs/5
'' SIG '' 9PesMHqai7Je1M/RQ0SbQyHrlnKhSLSZy51PpwYDE3cn
'' SIG '' RNTnf+hZqPC/Lwum6fI0POz3A8eHqNJMQBk1RmppVLC4
'' SIG '' oVaO7KTVPeix3P0c2PR3WlxUjG/voVA9/HYJaISfb8rb
'' SIG '' II01YBwCA8sgsKxYoA5AY8WYIsGyWfVVa88nq2x2zm8j
'' SIG '' LfR+cWojayL/ErhULSd+2DrZ8LaHlv1b0VysGMNNn3O3
'' SIG '' AamfV6peKOK5lDGCA3YwggNyAgEBMHcwYzELMAkGA1UE
'' SIG '' BhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTsw
'' SIG '' OQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
'' SIG '' OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQQIQC65mvFq6
'' SIG '' f5WHxvnpBOMzBDANBglghkgBZQMEAgEFAKCB0TAaBgkq
'' SIG '' hkiG9w0BCQMxDQYLKoZIhvcNAQkQAQQwHAYJKoZIhvcN
'' SIG '' AQkFMQ8XDTI1MDQxNzE0MzkyN1owKwYLKoZIhvcNAQkQ
'' SIG '' AgwxHDAaMBgwFgQU29OF7mLb0j575PZxSFCHJNWGW0Uw
'' SIG '' LwYJKoZIhvcNAQkEMSIEIEWfBNUg1aMVtqHzdYbN5zMZ
'' SIG '' r9vAtgd/4aZwcEXF+GWYMDcGCyqGSIb3DQEJEAIvMSgw
'' SIG '' JjAkMCIEIHZ2n6jyYy8fQws6IzCu1lZ1/tdz2wXWZbkF
'' SIG '' k5hDj5rbMA0GCSqGSIb3DQEBAQUABIICAIYdfIIwBOC6
'' SIG '' f63rvJIGyW3qLUkO1eEusZmrsruSn6DNg4zlIuKB4Osh
'' SIG '' DmIaUGIW5YNjeiGu9gMPYr6r6Zj/nMRExBe/0q4fj84L
'' SIG '' joYNpEQd+tRONhJ8uJDaCYO7P/Pm8co/LHGRdhF+aNHv
'' SIG '' tTTeGg8V43nxnzduqg+Sy7MUykOy/NM2OKsfFOoWHd0R
'' SIG '' n3H7aiFYTNbyUC06+SX7OMQ7FaIMFhMt0qialXfiI38R
'' SIG '' i+ijVJYjWQEFBk5moIrxUXx+rVYQKg2Rnv5z2FPwGw8q
'' SIG '' F0bEwaDCUuGY9QIsc6EoJ0e6JDGMpslx8CjZRshFwijY
'' SIG '' WQFQtwgxy3aatXTLce2vlnUErvzMbuTAon0hCcFz6qSJ
'' SIG '' VDpHhZ7Aa/5RHuLBINH9tX0NUxUS+uLARz5jR0QPNyoX
'' SIG '' 3JTgDXWSuskiSi5UjHhLKVXSbvXkxgUGgfDKDJoNowaO
'' SIG '' eg3I27I9HKCGZFQxJ2B+gSwZhDF1VNyK/I0fNCZa7h4W
'' SIG '' 18rrr3ZBOCfNQOcj9Lm4QSpjK2VsT4so2MOxuZTtY52i
'' SIG '' 3s7YsZUC9304f6sKPNxhEXo3zK+jeZrwpJsAYE779CS5
'' SIG '' tujRtlCmIORGpArCsFVTvsI1oiC4qapkZNjpG+aKCrOY
'' SIG '' z1F2ffbUHwOR3GSM2097BUY4Alcqq1e7SWZRKvOyrf0q
'' SIG '' UHphHTLiyLMY
'' SIG '' End signature block
